
#include "stdafx.h"
#include "PerformanceCounter.h"
#include <pdh.h>
#include <pdhmsg.h>

CPerformanceCounter::CPerformanceCounter()
{
	QueryHandle = NULL;
	NumCounters = 0;
	NumAllocated = 10;
	CounterHandle = new HCOUNTER[NumAllocated];
	CounterValue = new PDH_FMT_COUNTERVALUE[NumAllocated];
	CounterPaths = new CString[NumAllocated];
	CounterFormat = new DWORD[NumAllocated];
	LastUpdate = new DWORD[NumAllocated];

	memset(CounterHandle, 0, sizeof(HCOUNTER) * NumAllocated);
	memset(CounterValue, 0, sizeof(PDH_FMT_COUNTERVALUE) * NumAllocated);	
	memset(CounterFormat, 0, sizeof(DWORD) * NumAllocated);
	memset(LastUpdate, 0, sizeof(DWORD) * NumAllocated);
}

CPerformanceCounter::~CPerformanceCounter()
{
	Reset();

	PdhCloseQuery(QueryHandle);

	if(CounterHandle != NULL) 
	{
		delete[] CounterHandle;
		CounterHandle = NULL;
	}

	if(CounterValue != NULL)
	{
		delete[] CounterValue;
		CounterValue = NULL;
	}

	if(CounterPaths != NULL)
	{
		delete[] CounterPaths;
		CounterPaths = NULL;
	}

	if(CounterFormat != NULL)
	{
		delete[] CounterFormat;
		CounterFormat = NULL;
	}

	if(LastUpdate != NULL)
	{
		delete[] LastUpdate;
		LastUpdate = NULL;
	}
}

PDH_STATUS CPerformanceCounter::Initialize(void)
{
	PDH_STATUS RetVal = ERROR_SUCCESS;
	RetVal = PdhOpenQuery(0, 0, &QueryHandle);
	return RetVal;
}

PDH_STATUS CPerformanceCounter::AddCounterFromBrowser(HWND hwnd, CString start_path, DWORD counter_format)
{
	char CounterPath[500];
	PDH_STATUS RetVal = ERROR_SUCCESS;
	PDH_BROWSE_DLG_CONFIG BrowseInfo;
	memset(CounterPath, 0, 500);
	memset(&BrowseInfo, 0, sizeof(PDH_BROWSE_DLG_CONFIG));
	
	memcpy(CounterPath, start_path.GetBuffer(500), start_path.GetLength());

	BrowseInfo.bIncludeInstanceIndex = FALSE;     
	BrowseInfo.bSingleCounterPerAdd = TRUE;     
	BrowseInfo.bSingleCounterPerDialog = TRUE;     
	BrowseInfo.bLocalCountersOnly = FALSE;     
	BrowseInfo.bWildCardInstances = FALSE;     
	BrowseInfo.bHideDetailBox = FALSE;     
	BrowseInfo.bDisableMachineSelection = FALSE;     
	if(start_path.GetLength() > 0) BrowseInfo.bInitializePath = TRUE;     
	BrowseInfo.bIncludeCostlyObjects = TRUE;     
	BrowseInfo.hWndOwner = hwnd;     
	BrowseInfo.szReturnPathBuffer = CounterPath;     
	BrowseInfo.cchReturnPathLength = 500;     
	BrowseInfo.pCallBack = NULL;     
	BrowseInfo.dwCallBackArg = 0;     
	BrowseInfo.CallBackStatus = ERROR_SUCCESS;     
	BrowseInfo.dwDefaultDetailLevel = PERF_DETAIL_WIZARD;     
	BrowseInfo.szDialogBoxCaption = "Select a counter to monitor"; 

	RetVal = PdhBrowseCounters(&BrowseInfo);
	if(RetVal != ERROR_SUCCESS) return RetVal;

	RetVal = PdhAddCounter(QueryHandle, CounterPath, 0, &CounterHandle[NumCounters]);
	if(RetVal != ERROR_SUCCESS) return RetVal;

	CounterPaths[NumCounters] = CounterPath;
	CounterFormat[NumCounters] = counter_format;

	NumCounters++;

	if(NumCounters >= NumAllocated)
	{
		ResizeArrays();
	}

	return RetVal;
}

PDH_STATUS CPerformanceCounter::AddCounter(CString counter_path, DWORD counter_format)
{
	PDH_STATUS RetVal = ERROR_SUCCESS;

	RetVal = PdhAddCounter(QueryHandle, counter_path, 0, &CounterHandle[NumCounters]);
	if(RetVal != ERROR_SUCCESS) return RetVal;

	CounterPaths[NumCounters] = counter_path;
	CounterFormat[NumCounters] = counter_format;

	NumCounters++;

	if(NumCounters >= NumAllocated)
	{
		ResizeArrays();
	}

	return RetVal;
}

PDH_STATUS CPerformanceCounter::UpdateCounter(DWORD index)
{
	PDH_STATUS RetVal = ERROR_SUCCESS;
	DWORD counter_type = 0;
	DWORD i = 0;

	RetVal = PdhCollectQueryData(QueryHandle);
	if(RetVal != ERROR_SUCCESS) return RetVal;

	if((index >= 0) && (index < NumCounters))
	{
		RetVal = PdhGetFormattedCounterValue(CounterHandle[index], CounterFormat[index], &counter_type, &CounterValue[index]);
		if(RetVal != ERROR_SUCCESS) return RetVal;
		LastUpdate[index] = GetTickCount();
	}
	else
	if(index == UPDATE_ALL)
	{
		for(i=0; i<NumCounters; i++)
		{
			counter_type = 0;
			RetVal = PdhGetFormattedCounterValue(CounterHandle[i], CounterFormat[i], &counter_type, &CounterValue[i]);
			if(RetVal != ERROR_SUCCESS) return RetVal;
			LastUpdate[i] = GetTickCount();
		}
	}

	return RetVal;
}

PDH_STATUS CPerformanceCounter::Reset(void)
{
	DWORD i = 0;
	PDH_STATUS RetVal = ERROR_SUCCESS;

	for(i=0; i<NumCounters; i++)
	{
		RetVal = PdhRemoveCounter(CounterHandle[i]);
		if(RetVal != ERROR_SUCCESS) return RetVal;	
		
		CounterPaths[i].Empty();
	}

	memset(CounterHandle, 0, sizeof(HCOUNTER) * NumAllocated);
	memset(CounterValue, 0, sizeof(PDH_FMT_COUNTERVALUE) * NumAllocated);	
	memset(CounterFormat, 0, sizeof(DWORD) * NumAllocated);
	memset(LastUpdate, 0, sizeof(DWORD) * NumAllocated);

	NumCounters = 0;
	return RetVal;
}

int CPerformanceCounter::ResizeArrays(void)
{
	DWORD i = 0;
	HCOUNTER				*tmpCounterHandle = NULL;
	PDH_FMT_COUNTERVALUE	*tmpCounterValue = NULL;
	CString					*tmpCounterPaths = NULL;
	DWORD					*tmpCounterFormat = NULL;
	DWORD					*tmpLastUpdate = NULL;

	if((CounterHandle != NULL) && (CounterValue != NULL) && (CounterPaths != NULL) && 
	   (CounterFormat != NULL) && (LastUpdate != NULL))
	{
		tmpCounterHandle = new HCOUNTER[NumAllocated + 10];
		tmpCounterValue = new PDH_FMT_COUNTERVALUE[NumAllocated + 10];
		tmpCounterPaths = new CString[NumAllocated + 10];
		tmpCounterFormat = new DWORD[NumAllocated + 10];
		tmpLastUpdate = new DWORD[NumAllocated + 10];

		memset(tmpCounterHandle, 0, sizeof(HCOUNTER) * (NumAllocated + 10));
		memset(tmpCounterValue, 0, sizeof(PDH_FMT_COUNTERVALUE) * (NumAllocated + 10));
		memset(tmpCounterFormat, 0, sizeof(DWORD) * (NumAllocated + 10));
		memset(tmpLastUpdate, 0, sizeof(DWORD) * (NumAllocated + 10));

		for(i=0; i<NumAllocated + 10; i++) 
		{
			tmpCounterPaths[i].Empty();
		}

		memcpy(tmpCounterHandle, CounterHandle, sizeof(HCOUNTER) * NumAllocated);
		memcpy(tmpCounterValue, CounterValue, sizeof(PDH_FMT_COUNTERVALUE) * NumAllocated);
		memcpy(tmpCounterFormat, CounterFormat, sizeof(DWORD) * NumAllocated);
		memcpy(tmpLastUpdate, LastUpdate, sizeof(DWORD) * NumAllocated);
		
		for(i=0; i<NumAllocated; i++) 
		{
			tmpCounterPaths[i] = CounterPaths[i];
		}

		delete[] CounterHandle;
		delete[] CounterValue;
		delete[] CounterPaths;
		delete[] CounterFormat;
		delete[] LastUpdate;

		CounterHandle = tmpCounterHandle;
		CounterValue = tmpCounterValue;
		CounterPaths = tmpCounterPaths;
		CounterFormat = tmpCounterFormat;
		LastUpdate = tmpLastUpdate;

		tmpCounterHandle = NULL;
		tmpCounterValue = NULL;
		tmpCounterPaths = NULL;
		tmpCounterFormat = NULL;
		tmpLastUpdate = NULL;

		NumAllocated += 10;
	}

	if((CounterHandle != NULL) && (CounterValue != NULL) && (CounterPaths != NULL) && 
	   (CounterFormat != NULL) && (LastUpdate != NULL))
	{
		return 1;
	}
	
	return 0;
}

//*************************************************************************************************//

void __CheckForError(PDH_STATUS value, char *file, int line)
{
	CString msg, tackmsg;
	static int error = 0;

	if(error) return;

	msg.Format("Error occurred with code: %d, [UNKNOWN]", (int) value);

	if(value == ERROR_SUCCESS)
	{
		return;
	}
	else
	if(value == PDH_CSTATUS_BAD_COUNTERNAME)
	{
		msg.Format("Error occurred with code: %d, [PDH_CSTATUS_BAD_COUNTERNAME]", (int) value);
	}
	else
	if(value == PDH_CSTATUS_NO_COUNTER)
	{
		msg.Format("Error occurred with code: %d, [PDH_CSTATUS_NO_COUNTER]", (int) value);
	}
	else
	if(value == PDH_CSTATUS_NO_COUNTERNAME)
	{
		msg.Format("Error occurred with code: %d, [PDH_CSTATUS_NO_COUNTERNAME]", (int) value);
	}
	else
	if(value == PDH_CSTATUS_NO_MACHINE)
	{
		msg.Format("Error occurred with code: %d, [PDH_CSTATUS_NO_MACHINE]", (int) value);
	}
	else
	if(value == PDH_CSTATUS_NO_OBJECT)
	{
		msg.Format("Error occurred with code: %d, [PDH_CSTATUS_NO_OBJECT]", (int) value);
	}
	else
	if(value == PDH_FUNCTION_NOT_FOUND)
	{
		msg.Format("Error occurred with code: %d, [PDH_FUNCTION_NOT_FOUND]", (int) value);
	}
	else
	if(value == PDH_INVALID_ARGUMENT)
	{
		msg.Format("Error occurred with code: %d, [PDH_INVALID_ARGUMENT]", (int) value);
	}
	else
	if(value == PDH_INVALID_HANDLE)
	{
		msg.Format("Error occurred with code: %d, [PDH_INVALID_HANDLE]", (int) value);
	}
	else
	if(value == PDH_MEMORY_ALLOCATION_FAILURE)
	{
		msg.Format("Error occurred with code: %d, [PDH_MEMORY_ALLOCATION_FAILURE]", (int) value);
	}
	else
	if(value == PDH_NO_DATA)
	{
		msg.Format("Error occurred with code: %d, [PDH_NO_DATA]", (int) value);
	}
	else
	if(value == PDH_INVALID_DATA)
	{
		msg.Format("Error occurred with code: %d, [PDH_INVALID_DATA]", (int) value);
	}

	error = 1;
	tackmsg.Format("\n\nLine %d, File: %s", line, file);
	MessageBox(NULL, msg + tackmsg, "Error Detected:", MB_OK | MB_ICONERROR | MB_SYSTEMMODAL);
	exit(0);
}